
import weaviate
from dotenv import load_dotenv
from llama_index.core import (SimpleDirectoryReader, StorageContext,
                              VectorStoreIndex)
from llama_index.core.settings import Settings
from llama_index.embeddings.openai import OpenAIEmbedding
from llama_index.llms.openai import OpenAI
from llama_index.vector_stores.weaviate import WeaviateVectorStore
load_dotenv()

# Zmiana domyślnych ustawień, by kod używał GPT-4 oraz klasy OpenAIEmbedding
Settings.llm = OpenAI(model="gpt-4")
Settings.embed_model = OpenAIEmbedding()

# Połączenie się z klientem Weaviate I utworzenie bazy wektorowej
client = weaviate.Client(url="http://localhost:8080")
vector_store = WeaviateVectorStore(
    weaviate_client=client, index_name="BlogPost", text_key="content")

# Ustawienie bazy dla osadzeń
storage_context = StorageContext.from_defaults(vector_store=vector_store)


# Wczytanie dokumentów do folderu z danymi i utworzenie indeksów
documents = SimpleDirectoryReader("files").load_data()
index = VectorStoreIndex.from_documents(
    documents, storage_context=storage_context)

# Zapytanie o dane
query_engine = index.as_query_engine()
response = query_engine.query("What color is Link's outfit?")
print(response)
